/**
* \file: e_sdc_ecm_log.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: sdc-ecm-engine
*
* \author: Kirill Marinushkin (kmarinushkin@de.adit-jv.com)
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
***********************************************************************/

#ifndef SDC_ECM_ENGINE_SRC_E_SDC_ECM_LOG_H_
#define SDC_ECM_ENGINE_SRC_E_SDC_ECM_LOG_H_

#include <stdio.h>
#include <unistd.h>
#include <stdint.h>

/* numeric values for log levels */
#define SDC_ECM_LOGL_NONE           0
#define SDC_ECM_LOGL_ERR            1
#define SDC_ECM_LOGL_INFO           2
#define SDC_ECM_LOGL_DEBUG          3
#define SDC_ECM_LOGL_VERBOSE_DEBUG  4

#define DEF_LOGLEVEL    SDC_ECM_LOGL_ERR
#define DEF_LOGFILENAME "/tmp/sdc-ecm-engine.log"

extern int loglevel;
extern char logfilename[];

#define sdc_ecm_log(...) \
{ \
    FILE *fl = fopen(logfilename, "a+"); \
    if (fl) { \
        fprintf(fl, __VA_ARGS__); \
        fprintf(fl, "\n"); \
        fclose(fl); \
    } \
}

#define sdc_ecm_ext_dbg(...)    { if (loglevel >= SDC_ECM_LOGL_VERBOSE_DEBUG) sdc_ecm_log(__VA_ARGS__) }
#define sdc_ecm_dbg(...)        { if (loglevel >= SDC_ECM_LOGL_DEBUG) sdc_ecm_log(__VA_ARGS__) }
#define sdc_ecm_inf(...)        { if (loglevel >= SDC_ECM_LOGL_INFO) sdc_ecm_log(__VA_ARGS__) }
#define sdc_ecm_err(...)        { if (loglevel >= SDC_ECM_LOGL_ERR) sdc_ecm_log(__VA_ARGS__) }

void sdc_ecm_hexdump_data(const char *name, int desired_level,
                          const uint8_t *data, size_t len);

#endif /* SDC_ECM_ENGINE_SRC_E_SDC_ECM_LOG_H_ */
